#include <stdint.h>
#include <graphics.h>
#include <font.h>

#define BITSTREAMVERASERIF10_SPACE          4
#define BITSTREAMVERASERIF10_FIRST_CHAR     33
#define BITSTREAMVERASERIF10_CHARS          94
#define BITSTREAMVERASERIF10_HEIGHT         15
#define BITSTREAMVERASERIF10_WORDS_PER_LINE 2
#define BITSTREAMVERASERIF10_BITS_PER_PIXEL 2

uint16_t bitstreamveraserif10_data[BITSTREAMVERASERIF10_CHARS][BITSTREAMVERASERIF10_WORDS_PER_LINE * BITSTREAMVERASERIF10_HEIGHT + 1] =
{
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0E00, 0x0000,  0x0E00, 0x0000,  0x0D00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0000, 0x0000,  0x0A00, 0x0000,  0x0A00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x3300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0051, 0x4000,  0x0082, 0x0000,  0x00C3, 0x0000,  0x0FFF, 0xF000,  0x0149, 0x0000,  0x3FFF, 0xC000,  0x0218, 0x0000,  0x0514, 0x0000,  0x0520, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x1FE0, 0x0000,  0x332C, 0x0000,  0x330C, 0x0000,  0x1B00, 0x0000,  0x0364, 0x0000,  0x330C, 0x0000,  0x3718, 0x0000,  0x1FE0, 0x0000,  0x0300, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,},
    { 12, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1F40, 0x6000,  0x2080, 0xC000,  0x30C2, 0x4000,  0x2086, 0x0000,  0x1F48, 0x7D00,  0x0024, 0x8200,  0x0060, 0xC300,  0x0080, 0x8200,  0x0240, 0x7D00,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 12, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x0C1C, 0x0000,  0x090C, 0x0000,  0x0641, 0xFC00,  0x20A0, 0x2000,  0x3018, 0x5000,  0x3006, 0x8000,  0x180A, 0xC000,  0x07E4, 0x7C00,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0200, 0x0000,  0x0800, 0x0000,  0x1400, 0x0000,  0x2000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x2000, 0x0000,  0x1400, 0x0000,  0x0800, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x2000, 0x0000,  0x0800, 0x0000,  0x0500, 0x0000,  0x0200, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0200, 0x0000,  0x0500, 0x0000,  0x0800, 0x0000,  0x2000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0300, 0x0000,  0x9318, 0x0000,  0x1B90, 0x0000,  0x1B90, 0x0000,  0x9318, 0x0000,  0x0300, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x3FFF, 0xF000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0C00, 0x0000,  0x0800, 0x0000,  0x1000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2800, 0x0000,  0x2800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0200, 0x0000,  0x0500, 0x0000,  0x0900, 0x0000,  0x0C00, 0x0000,  0x0800, 0x0000,  0x1400, 0x0000,  0x2000, 0x0000,  0x3000, 0x0000,  0x6000, 0x0000,  0x5000, 0x0000,  0x8000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x0808, 0x0000,  0x2406, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x2406, 0x0000,  0x0808, 0x0000,  0x06E4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01C0, 0x0000,  0x06C0, 0x0000,  0x08C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0FFC, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1BE0, 0x0000,  0x3418, 0x0000,  0x300C, 0x0000,  0x0008, 0x0000,  0x0020, 0x0000,  0x0050, 0x0000,  0x0240, 0x0000,  0x080C, 0x0000,  0x3FFC, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0BE4, 0x0000,  0x340C, 0x0000,  0x3018, 0x0000,  0x02E0, 0x0000,  0x0014, 0x0000,  0x000C, 0x0000,  0x300C, 0x0000,  0x3418, 0x0000,  0x1BD0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0070, 0x0000,  0x00B0, 0x0000,  0x0230, 0x0000,  0x0530, 0x0000,  0x1830, 0x0000,  0x3FFF, 0x0000,  0x0030, 0x0000,  0x0030, 0x0000,  0x03FF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FF0, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x37D0, 0x0000,  0x3414, 0x0000,  0x000C, 0x0000,  0x300C, 0x0000,  0x3414, 0x0000,  0x1BD0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01F9, 0x0000,  0x0903, 0x0000,  0x1400, 0x0000,  0x26F4, 0x0000,  0x3405, 0x0000,  0x3003, 0x0000,  0x2003, 0x0000,  0x1405, 0x0000,  0x06F4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFC, 0x0000,  0x3014, 0x0000,  0x0020, 0x0000,  0x0020, 0x0000,  0x0050, 0x0000,  0x00C0, 0x0000,  0x0140, 0x0000,  0x0200, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0BF8, 0x0000,  0x3407, 0x0000,  0x2406, 0x0000,  0x0BF8, 0x0000,  0x1405, 0x0000,  0x3003, 0x0000,  0x3003, 0x0000,  0x1405, 0x0000,  0x07F4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07E4, 0x0000,  0x1405, 0x0000,  0x3002, 0x0000,  0x3003, 0x0000,  0x1407, 0x0000,  0x07E6, 0x0000,  0x0005, 0x0000,  0x3018, 0x0000,  0x1BD0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2800, 0x0000,  0x2800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2800, 0x0000,  0x2800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2800, 0x0000,  0x2800, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0C00, 0x0000,  0x0800, 0x0000,  0x2000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0001, 0x8000,  0x006D, 0x0000,  0x0790, 0x0000,  0x3800, 0x0000,  0x0790, 0x0000,  0x006D, 0x0000,  0x0001, 0x8000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x2400, 0x0000,  0x0790, 0x0000,  0x006D, 0x0000,  0x0002, 0xC000,  0x006D, 0x0000,  0x0790, 0x0000,  0x2400, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1B80, 0x0000,  0x3460, 0x0000,  0x3030, 0x0000,  0x0030, 0x0000,  0x0090, 0x0000,  0x0380, 0x0000,  0x0000, 0x0000,  0x0280, 0x0000,  0x0280, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 13, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x006F, 0x9000,  0x0640, 0x6400,  0x0800, 0x0900,  0x142D, 0xC200,  0x3091, 0xC300,  0x30C0, 0xC200,  0x3091, 0xC900,  0x142D, 0xE400,  0x0C00, 0x0000,  0x0740, 0x1000,  0x007E, 0x4000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x00A0, 0x0000,  0x01B0, 0x0000,  0x0254, 0x0000,  0x020C, 0x0000,  0x0505, 0x0000,  0x0C02, 0x0000,  0x1FFF, 0x4000,  0x3001, 0x8000,  0xFC02, 0xF000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFE, 0x0000,  0x0C01, 0x8000,  0x0C00, 0xC000,  0x0C01, 0x8000,  0x0FFE, 0x0000,  0x0C01, 0x8000,  0x0C00, 0xC000,  0x0C01, 0x8000,  0x3FFE, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01FD, 0x0000,  0x0902, 0xC000,  0x1400, 0xC000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x1400, 0x8000,  0x0902, 0x4000,  0x01F9, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FF9, 0x0000,  0x0C06, 0x8000,  0x0C00, 0x5000,  0x0C00, 0x3000,  0x0C00, 0x3000,  0x0C00, 0x3000,  0x0C00, 0x5000,  0x0C06, 0x8000,  0x3FF9, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0xC000,  0x0C00, 0xC000,  0x0C00, 0x0000,  0x0C03, 0x0000,  0x0FFF, 0x0000,  0x0C03, 0x0000,  0x0C00, 0x0000,  0x0C00, 0xC000,  0x3FFF, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0xC000,  0x0C00, 0xC000,  0x0C00, 0x0000,  0x0C03, 0x0000,  0x0FFF, 0x0000,  0x0C03, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3FC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01BE, 0x4000,  0x0901, 0xB000,  0x1400, 0x3000,  0x3000, 0x0000,  0x3003, 0xF000,  0x3000, 0x3000,  0x1400, 0x3000,  0x0900, 0x7000,  0x01BE, 0x4000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F03, 0xF000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0FFF, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x3F03, 0xF000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x1800, 0x0000,  0xE000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F2F, 0x0000,  0x0C08, 0x0000,  0x0C20, 0x0000,  0x0C80, 0x0000,  0x0E40, 0x0000,  0x0CD0, 0x0000,  0x0C34, 0x0000,  0x0C0D, 0x0000,  0x3F03, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C03, 0x0000,  0x0C03, 0x0000,  0x3FFF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 13, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3E00, 0x1F00,  0x0E40, 0x2C00,  0x0C80, 0x4C00,  0x0C90, 0x8C00,  0x0C21, 0x0C00,  0x0C25, 0x0C00,  0x0C0C, 0x0C00,  0x0C00, 0x0C00,  0x3F00, 0x3F00,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 12, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3E00, 0xFC00,  0x0E40, 0x3000,  0x0C90, 0x3000,  0x0C20, 0x3000,  0x0C18, 0x3000,  0x0C05, 0x3000,  0x0C02, 0x7000,  0x0C00, 0xB000,  0x3F00, 0x3000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01FD, 0x0000,  0x0901, 0xC000,  0x1400, 0x5000,  0x3000, 0x3000,  0x3000, 0x3000,  0x3000, 0x3000,  0x1400, 0x5000,  0x0901, 0x8000,  0x01FD, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FF8, 0x0000,  0x0C06, 0x0000,  0x0C03, 0x0000,  0x0C06, 0x0000,  0x0FF4, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x01FD, 0x0000,  0x0901, 0xC000,  0x1400, 0x5000,  0x3000, 0x3000,  0x3000, 0x3000,  0x3000, 0x3000,  0x1400, 0x5000,  0x0D01, 0xC000,  0x01BD, 0x0000,  0x0009, 0x0000,  0x0001, 0xC000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FF8, 0x0000,  0x0C06, 0x0000,  0x0C03, 0x0000,  0x0C06, 0x0000,  0x0FF8, 0x0000,  0x0C08, 0x0000,  0x0C06, 0x0000,  0x0C02, 0x0000,  0x3F01, 0xE000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07F4, 0x0000,  0x240B, 0x0000,  0x3003, 0x0000,  0x1900, 0x0000,  0x01B8, 0x0000,  0x0006, 0x0000,  0x3003, 0x0000,  0x3406, 0x0000,  0x0BF8, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFFFF, 0xC000,  0xC0C0, 0xC000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x03F0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3F03, 0xF000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0C00, 0xC000,  0x0602, 0x4000,  0x01FD, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF801, 0xF000,  0x2000, 0x8000,  0x1402, 0x4000,  0x0C03, 0x0000,  0x0505, 0x0000,  0x020C, 0x0000,  0x0254, 0x0000,  0x01B0, 0x0000,  0x00A0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 13, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF80C, 0x0FC0,  0x301D, 0x0300,  0x2426, 0x0600,  0x1423, 0x0500,  0x0C51, 0x4C00,  0x0880, 0x8800,  0x0580, 0x9400,  0x0740, 0x7400,  0x0300, 0x3000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFC0B, 0xC000,  0x1405, 0x0000,  0x0808, 0x0000,  0x0260, 0x0000,  0x00C0, 0x0000,  0x0260, 0x0000,  0x0808, 0x0000,  0x2406, 0x0000,  0xFC0F, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  9, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFC0B, 0xC000,  0x2405, 0x0000,  0x0808, 0x0000,  0x0220, 0x0000,  0x0190, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x03F0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 10, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFF, 0x8000,  0x3002, 0x0000,  0x000D, 0x0000,  0x0024, 0x0000,  0x0050, 0x0000,  0x0180, 0x0000,  0x0700, 0x0000,  0x0C00, 0xC000,  0x2FFF, 0xC000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x3E00, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3E00, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x8000, 0x0000,  0x5000, 0x0000,  0x6000, 0x0000,  0x3000, 0x0000,  0x2000, 0x0000,  0x1400, 0x0000,  0x0800, 0x0000,  0x0C00, 0x0000,  0x0900, 0x0000,  0x0500, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x3F00, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x0300, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x00F0, 0x0000,  0x02A8, 0x0000,  0x0906, 0x0000,  0x1401, 0x4000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFFFC, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0600, 0x0000,  0x0140, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x06E0, 0x0000,  0x0D18, 0x0000,  0x000C, 0x0000,  0x0BFC, 0x0000,  0x300C, 0x0000,  0x341C, 0x0000,  0x1BDF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0DF4, 0x0000,  0x0D05, 0x0000,  0x0C03, 0x0000,  0x0C03, 0x0000,  0x0C03, 0x0000,  0x0D05, 0x0000,  0x3DF4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07E4, 0x0000,  0x141C, 0x0000,  0x2000, 0x0000,  0x3000, 0x0000,  0x2000, 0x0000,  0x1418, 0x0000,  0x07E0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x003C, 0x0000,  0x000C, 0x0000,  0x000C, 0x0000,  0x07DC, 0x0000,  0x141C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x141C, 0x0000,  0x07DF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07D0, 0x0000,  0x1414, 0x0000,  0x3008, 0x0000,  0x3FFC, 0x0000,  0x2000, 0x0000,  0x1418, 0x0000,  0x07E0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x07F0, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3FC0, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3FC0, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07DF, 0x0000,  0x141C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x141C, 0x0000,  0x07DC, 0x0000,  0x000C, 0x0000,  0x3414, 0x0000,  0x1BD0, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0DF4, 0x0000,  0x0D18, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x3F3F, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0800, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0800, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0xF400, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C3D, 0x0000,  0x0C24, 0x0000,  0x0CD0, 0x0000,  0x0FD0, 0x0000,  0x0D30, 0x0000,  0x0C18, 0x0000,  0x3F2F, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x3C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 12, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3DF5, 0xF400,  0x0D19, 0x1800,  0x0C0C, 0x0C00,  0x0C0C, 0x0C00,  0x0C0C, 0x0C00,  0x0C0C, 0x0C00,  0x3F3F, 0x3F00,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3DF4, 0x0000,  0x0D18, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x3F3F, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x06E4, 0x0000,  0x1809, 0x0000,  0x2002, 0x0000,  0x3003, 0x0000,  0x2002, 0x0000,  0x1809, 0x0000,  0x06E4, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3DF4, 0x0000,  0x0D05, 0x0000,  0x0C03, 0x0000,  0x0C03, 0x0000,  0x0C03, 0x0000,  0x0D05, 0x0000,  0x0DF4, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x07DF, 0x0000,  0x141C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x300C, 0x0000,  0x141C, 0x0000,  0x07DC, 0x0000,  0x000C, 0x0000,  0x000C, 0x0000,  0x003F, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3DF0, 0x0000,  0x0D30, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x3F00, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  6, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1B90, 0x0000,  0x3030, 0x0000,  0x3400, 0x0000,  0x0B40, 0x0000,  0x0060, 0x0000,  0x3030, 0x0000,  0x1B90, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  5, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0xFF40, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x3000, 0x0000,  0x30C0, 0x0000,  0x1F40, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3C3C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x0C0C, 0x0000,  0x091C, 0x0000,  0x07DF, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF8FC, 0x0000,  0x3020, 0x0000,  0x1450, 0x0000,  0x0880, 0x0000,  0x0980, 0x0000,  0x0740, 0x0000,  0x0200, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xFC30, 0xBC00,  0x3074, 0x3000,  0x1454, 0x5000,  0x0888, 0x8000,  0x0949, 0x8000,  0x0646, 0x4000,  0x0303, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF8FC, 0x0000,  0x2450, 0x0000,  0x0980, 0x0000,  0x0340, 0x0000,  0x09C0, 0x0000,  0x1460, 0x0000,  0xF8BC, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0xF4FC, 0x0000,  0x6030, 0x0000,  0x2060, 0x0000,  0x1490, 0x0000,  0x0CC0, 0x0000,  0x0A40, 0x0000,  0x0700, 0x0000,  0x0200, 0x0000,  0x0500, 0x0000,  0xF800, 0x0000,},
    {  7, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x3FFC, 0x0000,  0x3030, 0x0000,  0x0090, 0x0000,  0x0140, 0x0000,  0x0600, 0x0000,  0x0C0C, 0x0000,  0x3FFC, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x007C, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0180, 0x0000,  0x0F00, 0x0000,  0x0180, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x007C, 0x0000,  0x0000, 0x0000,},
    {  4, 0x0000, 0x0000,  0x0000, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,  0x0C00, 0x0000,},
    {  8, 0x0000, 0x0000,  0x0000, 0x0000,  0x0E40, 0x0000,  0x0080, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0090, 0x0000,  0x003C, 0x0000,  0x0090, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x00C0, 0x0000,  0x0F40, 0x0000,  0x0000, 0x0000,},
    { 11, 0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x1B90, 0x8000,  0x106E, 0x4000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,  0x0000, 0x0000,}
};

const font_t bitstreamveraserif10 = {BITSTREAMVERASERIF10_BITS_PER_PIXEL, BITSTREAMVERASERIF10_WORDS_PER_LINE, BITSTREAMVERASERIF10_HEIGHT, BITSTREAMVERASERIF10_HEIGHT - (BITSTREAMVERASERIF10_HEIGHT >> 2), BITSTREAMVERASERIF10_FIRST_CHAR, BITSTREAMVERASERIF10_CHARS, BITSTREAMVERASERIF10_SPACE, bitstreamveraserif10_data[0] };

